-----------------------------------------------------------------------------
--
--  Logical unit: InvoiceAuthorizer
--  Component:    INVOIC
--
--  IFS Developer Studio Template Version 3.0
--
--  Date    Sign     History
--  ------  ------   ---------------------------------------------------------
--  960508  ToWi     Created
--  960529  JoTh     Module name changed
--                   Exist control of superior authorizers implemented
--                   Check of subauthorizers (Check_Sub_Authorizers) implemented
--                   Check of cross reference (Check_Cross_Reference) implemented
--                   USER_ACCESS_API-call remarked
--  960618  JoTh     Check_Cross_Reference debuged
--  960906  PiCz     Function Get_Max_Amount added
--  971097  GeTh     Added user_id and notify_users columns and get functions.
--  980601  MeBe     Fit to IFS/Design 2.1.1A.
--  981119  WOBL     column user_id is not mandatory bug supp id 6466 Ext Bug 6229
--  981127  ASRE     Modify of user_id does not work correctly, bug # 6229.
--  990104  MarK     Company expanded to 20 in comments, Party_Type expanded to 20
--  990624  DaCa     Changed to new Template.
--  991203  BmEk     Removed commented code.
--  000728  DaCa     Corrected Init_Method Calls for security
--  010214  LiSv     For new Create Company concept added new view invoice_authorizer_etc and invoice_authorizer_pct. 
--                   Added procedures Make_Company, Copy___, Import___ and Export___.
--  010816  OVJOSE   Added Create Company translation method Create_Company_Translations___
--  011219  SHSALK   IID 20001 Enhancement of Update Company. Changes inside make_company method
--                   Changed Import___, Export___ and Copy___ methods to use records
--  020129  THSRLK   IID 20004 - Removed def_tab from  methord Export___
--  020214  Mnisse   IID 21003, added translation support for description
--  020221  THSRLK   Removed Create_Company_Translations___
--  020612  ovjose   Bug 29600 Corrected. Removed function call in INVOICE_AUTHORIZER_PCT.
--  020923  ChFolk   Merged the IceAge code.
--  030219  PPerse   Merge TakeOff
--  030801  LoKrLK   SP4 Merge (32282,37227)
--  031010  TiUkLk   LCS Patch Merge added Function Get_Sup_Authorizer. 
--  040628  anpelk   FIPR338A2: Unicode Changes.
--  070510  Prdilk   B141476, Modified Unpack_Check_Update___ to support translations.
--  070906  Shwilk   LCS merge 66671, Function Is_Authorizer_Exist added.
--  110507  Kanslk   EASTONE-14811, Merge Bug 96572,Modified Unpack_Check_Update___().
--  111127  Shdilk   SFI-891, Removed general_sys from Is_Authorizer_Exist.
--  110829  Hecolk   Bug 111220, Corrected END Statement of local procedure Check_Sub_Authorizers in PROCEDURE Check_Delete__
--  140408  THPELK   PBFI-4177, LCS Merge (Bug 113510).
--  140812  Kagalk   PRFI-1493, Merged Bug 118082, Enable to use a hierarchy of superior authorizers.
--  150717  Chwtlk   Bug 123515, Modified Get_Max_Supp_Auth_Amount Procedure.
-----------------------------------------------------------------------------

layer Core;

-------------------- PUBLIC DECLARATIONS ------------------------------------
                     
-------------------- PRIVATE DECLARATIONS -----------------------------------
                     
-------------------- LU SPECIFIC IMPLEMENTATION METHODS ---------------------

@Override
PROCEDURE Import_Assign___ (
   newrec_      IN OUT invoice_authorizer_tab%ROWTYPE,
   crecomp_rec_ IN     Enterp_Comp_Connect_V170_API.Crecomp_Lu_Public_Rec,
   pub_rec_     IN     Create_Company_Template_Pub%ROWTYPE )
IS
BEGIN
   super(newrec_, crecomp_rec_, pub_rec_);
   IF (newrec_.user_id  = '<FNDUSER>') THEN
      newrec_.user_id := Fnd_Session_API.Get_Fnd_User;
   END IF;
END Import_Assign___;


@Override
PROCEDURE Export___ (
   crecomp_rec_ IN Enterp_Comp_Connect_V170_API.Crecomp_Lu_Public_Rec )
IS
   pub_rec_  Enterp_Comp_Connect_V170_API.Tem_Public_Rec;
   i_        NUMBER := 1;
   CURSOR get_def_data IS
      SELECT c1, c2, n1, c3, c4, c5
      FROM   create_company_template_pub
      WHERE  component = module_
      AND    lu = lu_name_
      AND    template_id = crecomp_rec_.user_template_id;      
BEGIN
   IF (crecomp_rec_.user_template_id IS NULL) THEN
      -- Call to super to avoid duplicate code (overtake)
      super(crecomp_rec_);
   ELSE
      FOR pctrec_ IN get_def_data LOOP
         pub_rec_.template_id := crecomp_rec_.template_id;
         pub_rec_.component   := module_;
         pub_rec_.version     := crecomp_rec_.version;
         pub_rec_.lu          := lu_name_;
         pub_rec_.item_id     := i_;
         pub_rec_.c1          := pctrec_.c1;
         pub_rec_.c2          := pctrec_.c2;
         pub_rec_.n1          := pctrec_.n1;
         pub_rec_.c3          := pctrec_.c3;
         IF (pctrec_.c4 = '<APPOWNER>') THEN
            -- Using <APPOWNER> was an old construction used prior to Invoic 1.13.0
            pub_rec_.c4       := '<FNDUSER>';
         ELSE
            pub_rec_.c4       := pctrec_.c4;
         END IF; 
         pub_rec_.c5          := pctrec_.c5;
         Enterp_Comp_Connect_V170_API.Tem_Insert_Detail_Data(pub_rec_);
         i_ := i_ + 1;
      END LOOP;   
   END IF;
END Export___;


PROCEDURE Check_Cross_Reference___ (
   company_          IN VARCHAR2,
   auth_id_          IN VARCHAR2,
   sup_authorizer_   IN VARCHAR2 )
IS
   cross_reference_        VARCHAR2(50);
   cross_reference_exist   EXCEPTION;
   CURSOR cross_control IS
      SELECT   auth_id
      FROM     (SELECT * 
                FROM invoice_authorizer_tab
                WHERE    company = company_)
      WHERE     auth_id = sup_authorizer_
      CONNECT BY PRIOR auth_id = sup_authorizer
      START WITH auth_id = auth_id_;
BEGIN
   OPEN cross_control;
   FETCH cross_control INTO cross_reference_;
   IF (cross_control%NOTFOUND) THEN
      CLOSE cross_control;
   ELSE
      CLOSE cross_control;
      RAISE cross_reference_exist;
   END IF;
EXCEPTION
   WHEN cross_reference_exist THEN
      Error_SYS.Appl_General(lu_name_, 'CROSSEXIST: Cross reference exist');
END Check_Cross_Reference___;


PROCEDURE Check_Sub_Authorizers___ (
   company_ IN VARCHAR2,
   auth_id_ IN VARCHAR2 )
IS
   sub_authorizer_      VARCHAR2(50);
   sub_authorizer_exist EXCEPTION;
   CURSOR sub_control IS
      SELECT auth_id
      FROM   invoice_authorizer_tab
      WHERE  company = company_
      AND    sup_authorizer = auth_id_;
BEGIN
   OPEN sub_control;
   FETCH sub_control INTO sub_authorizer_;
   IF (sub_control%NOTFOUND) THEN
      CLOSE sub_control;
   ELSE
      CLOSE sub_control;
      RAISE sub_authorizer_exist;
   END IF;
EXCEPTION
   WHEN sub_authorizer_exist THEN
      Error_SYS.Appl_General(lu_name_, 'SUBEXIST: Subauthorizers exist for authorizer' );
END Check_Sub_Authorizers___;


@Override
PROCEDURE Raise_Record_Not_Exist___ (
   company_ IN VARCHAR2,
   auth_id_ IN VARCHAR2 )
IS
BEGIN
   Error_SYS.Record_Not_Exist(lu_name_, NULL, auth_id_);
   super(company_, auth_id_);
END Raise_Record_Not_Exist___;


@Override
PROCEDURE Check_Delete___ (
   remrec_ IN invoice_authorizer_tab%ROWTYPE )
IS
BEGIN
   Check_Sub_Authorizers___(remrec_.company, remrec_.auth_id);
   super(remrec_);
END Check_Delete___;


@Override
PROCEDURE Check_Common___ (
   oldrec_ IN     invoice_authorizer_tab%ROWTYPE,
   newrec_ IN OUT invoice_authorizer_tab%ROWTYPE,
   indrec_ IN OUT Indicator_Rec,
   attr_   IN OUT VARCHAR2 )
IS
BEGIN   
   -- Ensure max_amount is rounded according the currency code setting in the company.
   newrec_.max_amount := Currency_Amount_API.Get_Rounded_Amount(newrec_.company, Company_Finance_API.Get_Currency_Code(newrec_.company), newrec_.max_amount);      
   IF (newrec_.max_amount < 0) THEN 
      Error_SYS.Record_General(lu_name_, 'INVAMOUNT: Maximum Amount must be greater than zero!');
   END IF;      
   IF (newrec_.notify_user IS NULL) THEN
      newrec_.notify_user := 'FALSE';
   END IF;
   super(oldrec_, newrec_, indrec_, attr_);
END Check_Common___;


@Override
PROCEDURE Check_Update___ (
   oldrec_ IN     invoice_authorizer_tab%ROWTYPE,
   newrec_ IN OUT invoice_authorizer_tab%ROWTYPE,
   indrec_ IN OUT Indicator_Rec,
   attr_   IN OUT VARCHAR2 )
IS
BEGIN
   super(oldrec_, newrec_, indrec_, attr_);
   IF (newrec_.sup_authorizer IS NOT NULL) THEN 
      Check_Cross_Reference___(newrec_.company, newrec_.auth_id, newrec_.sup_authorizer);
   END IF;
END Check_Update___;


-------------------- LU SPECIFIC PRIVATE METHODS ----------------------------

-------------------- LU SPECIFIC PROTECTED METHODS --------------------------

-------------------- LU SPECIFIC PUBLIC METHODS -----------------------------


FUNCTION Get_Auth_Id_By_Name (
   company_ IN VARCHAR2,
   name_    IN VARCHAR2 ) RETURN VARCHAR2
IS
   CURSOR get_auth_id IS
      SELECT auth_id
      FROM   invoice_authorizer_tab
      WHERE  company = company_
      AND    UPPER(name) = UPPER(name_); 
   auth_id_ invoice_authorizer_tab.auth_id%TYPE;
BEGIN
   OPEN get_auth_id;
   FETCH get_auth_id INTO auth_id_;
   CLOSE get_auth_id;
   RETURN auth_id_;   
END Get_Auth_Id_By_Name;


@UncheckedAccess
PROCEDURE Get_Control_Type_Value_Desc (
   description_   OUT VARCHAR2,
   company_       IN VARCHAR2,
   auth_id_       IN VARCHAR2 )
IS
BEGIN
   description_ := Get_Name(company_, auth_id_);
END Get_Control_Type_Value_Desc;


@UncheckedAccess
FUNCTION Is_Authorizer_Exist (
   company_  IN VARCHAR2,
   auth_id_  IN VARCHAR2 ) RETURN VARCHAR2
IS
BEGIN
   IF (NOT Check_Exist___(company_, auth_id_)) THEN
      RETURN 'FALSE';
   ELSE
      RETURN 'TRUE';
   END IF;
END Is_Authorizer_Exist;


@UncheckedAccess
PROCEDURE Get_Max_Supp_Auth_Amount (
   supp_auth_id_ OUT invoice_authorizer_tab.auth_id%TYPE,
   sup_max_amnt_ OUT NUMBER,
   company_      IN  VARCHAR2,
   auth_id_      IN  VARCHAR2 )
IS
   CURSOR get_valid_supp_auth IS 
      SELECT a.max_amount, a.auth_id 
      FROM   invoice_authorizer_tab a  
      WHERE  EXISTS (SELECT 1 
                     FROM   invoice_authorizer_tab b  
                     WHERE  b.company = company_ 
                     AND    b.auth_id = auth_id_
                     AND    b.sup_authorizer IS NOT NULL ) 
      AND    a.company    = company_   
      AND    a.user_id    = Fnd_Session_API.Get_Fnd_User()
      CONNECT BY NOCYCLE auth_id = PRIOR sup_authorizer
      AND    company      = PRIOR company
      START WITH auth_id  = auth_id_
      AND    a.company    = company_
      ORDER BY LEVEL DESC;
BEGIN
   -- returns the supp authorizer, and max_amount if there is a valid supp auth exists
   OPEN get_valid_supp_auth;
   FETCH get_valid_supp_auth INTO sup_max_amnt_, supp_auth_id_;
   IF (get_valid_supp_auth%FOUND) THEN
      CLOSE get_valid_supp_auth;
      IF (supp_auth_id_ = auth_id_) THEN
         supp_auth_id_ := NULL;
         sup_max_amnt_ := NULL;
      END IF;      
   ELSE          
      CLOSE get_valid_supp_auth;
      supp_auth_id_ := NULL;
      sup_max_amnt_ := NULL;
   END IF;
END Get_Max_Supp_Auth_Amount;

