-----------------------------------------------------------------------------
-- This file shows three examples of overrides. 
-----------------------------------------------------------------------------

@Override
PROCEDURE Import_Assign___ (
   newrec_      IN OUT accounting_code_part_value_tab%ROWTYPE,
   crecomp_rec_ IN     Enterp_Comp_Connect_V170_API.Crecomp_Lu_Public_Rec,
   pub_rec_     IN     Create_Company_Template_Pub%ROWTYPE )
IS
BEGIN
   super(newrec_, crecomp_rec_, pub_rec_);
   newrec_.code_part             := pc_code_part_;
   newrec_.valid_from            := crecomp_rec_.valid_from;
   newrec_.cons_code_part_value  := null;
   IF ( newrec_.description IS NULL ) THEN
      newrec_.description := newrec_.code_part_value;
   END IF;
END Import_Assign___;


@Override
PROCEDURE Copy_Assign___ (
   newrec_      IN OUT accounting_code_part_value_tab%ROWTYPE,
   crecomp_rec_ IN     Enterp_Comp_Connect_V170_API.Crecomp_Lu_Public_Rec,
   oldrec_      IN     accounting_code_part_value_tab%ROWTYPE )
IS
BEGIN
   super(newrec_, crecomp_rec_, oldrec_);
   newrec_.code_part            := pc_code_part_;
   newrec_.valid_from           := crecomp_rec_.valid_from;
   newrec_.cons_code_part_value := NULL;
END Copy_Assign___;


@Override
PROCEDURE Make_Company (
   attr_ IN     VARCHAR2 )
IS
   make_company_  VARCHAR2(20);
BEGIN
   make_company_ := Client_SYS.Get_Item_Value('MAKE_COMPANY', attr_);
   super(attr_);
   IF (make_company_ = 'MODIFY_KEY_DATE') THEN
      -- Making use of the Modify_Key_Date call to update the key in the template for diff 
      -- template functionality since the LU is making use of a sequence as part of the key.
      Modify_Key_Diff_Template___(attr_);
   END IF;
END Make_Company;
-----------------------------------------------------------------------------
